package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  CreationTime,
  StorageVirtualMachineId,
  FileSystemId,
  StorageVirtualMachineName,
  ResourceARN,
  UUID
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StorageVirtualMachine(
    activeDirectoryConfiguration: Option[
      zio.aws.fsx.model.SvmActiveDirectoryConfiguration
    ] = None,
    creationTime: Option[CreationTime] = None,
    endpoints: Option[zio.aws.fsx.model.SvmEndpoints] = None,
    fileSystemId: Option[FileSystemId] = None,
    lifecycle: Option[zio.aws.fsx.model.StorageVirtualMachineLifecycle] = None,
    name: Option[StorageVirtualMachineName] = None,
    resourceARN: Option[ResourceARN] = None,
    storageVirtualMachineId: Option[StorageVirtualMachineId] = None,
    subtype: Option[zio.aws.fsx.model.StorageVirtualMachineSubtype] = None,
    uuid: Option[UUID] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None,
    lifecycleTransitionReason: Option[
      zio.aws.fsx.model.LifecycleTransitionReason
    ] = None,
    rootVolumeSecurityStyle: Option[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.StorageVirtualMachine = {
    import StorageVirtualMachine.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
      .builder()
      .optionallyWith(
        activeDirectoryConfiguration.map(value => value.buildAwsValue())
      )(_.activeDirectoryConfiguration)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(endpoints.map(value => value.buildAwsValue()))(
        _.endpoints
      )
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        name.map(value =>
          StorageVirtualMachineName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        storageVirtualMachineId.map(value =>
          StorageVirtualMachineId.unwrap(value): java.lang.String
        )
      )(_.storageVirtualMachineId)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(uuid.map(value => UUID.unwrap(value): java.lang.String))(
        _.uuid
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lifecycleTransitionReason.map(value => value.buildAwsValue())
      )(_.lifecycleTransitionReason)
      .optionallyWith(rootVolumeSecurityStyle.map(value => value.unwrap))(
        _.rootVolumeSecurityStyle
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.StorageVirtualMachine.ReadOnly =
    zio.aws.fsx.model.StorageVirtualMachine.wrap(buildAwsValue())
}
object StorageVirtualMachine {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.StorageVirtualMachine =
      zio.aws.fsx.model.StorageVirtualMachine(
        activeDirectoryConfiguration.map(value => value.asEditable),
        creationTime.map(value => value),
        endpoints.map(value => value.asEditable),
        fileSystemId.map(value => value),
        lifecycle.map(value => value),
        name.map(value => value),
        resourceARN.map(value => value),
        storageVirtualMachineId.map(value => value),
        subtype.map(value => value),
        uuid.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lifecycleTransitionReason.map(value => value.asEditable),
        rootVolumeSecurityStyle.map(value => value)
      )
    def activeDirectoryConfiguration
        : Option[zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly]
    def creationTime: Option[CreationTime]
    def endpoints: Option[zio.aws.fsx.model.SvmEndpoints.ReadOnly]
    def fileSystemId: Option[FileSystemId]
    def lifecycle: Option[zio.aws.fsx.model.StorageVirtualMachineLifecycle]
    def name: Option[StorageVirtualMachineName]
    def resourceARN: Option[ResourceARN]
    def storageVirtualMachineId: Option[StorageVirtualMachineId]
    def subtype: Option[zio.aws.fsx.model.StorageVirtualMachineSubtype]
    def uuid: Option[UUID]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def lifecycleTransitionReason
        : Option[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly]
    def rootVolumeSecurityStyle
        : Option[zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle]
    def getActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeDirectoryConfiguration",
      activeDirectoryConfiguration
    )
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndpoints
        : ZIO[Any, AwsError, zio.aws.fsx.model.SvmEndpoints.ReadOnly] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachineLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getName: ZIO[Any, AwsError, StorageVirtualMachineName] =
      AwsError.unwrapOptionField("name", name)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getStorageVirtualMachineId
        : ZIO[Any, AwsError, StorageVirtualMachineId] = AwsError
      .unwrapOptionField("storageVirtualMachineId", storageVirtualMachineId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachineSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getUuid: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("uuid", uuid)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLifecycleTransitionReason: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleTransitionReason",
      lifecycleTransitionReason
    )
    def getRootVolumeSecurityStyle: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = AwsError.unwrapOptionField(
      "rootVolumeSecurityStyle",
      rootVolumeSecurityStyle
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
  ) extends zio.aws.fsx.model.StorageVirtualMachine.ReadOnly {
    override val activeDirectoryConfiguration
        : Option[zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly] =
      scala
        .Option(impl.activeDirectoryConfiguration())
        .map(value =>
          zio.aws.fsx.model.SvmActiveDirectoryConfiguration.wrap(value)
        )
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val endpoints: Option[zio.aws.fsx.model.SvmEndpoints.ReadOnly] =
      scala
        .Option(impl.endpoints())
        .map(value => zio.aws.fsx.model.SvmEndpoints.wrap(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val lifecycle
        : Option[zio.aws.fsx.model.StorageVirtualMachineLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value =>
        zio.aws.fsx.model.StorageVirtualMachineLifecycle.wrap(value)
      )
    override val name: Option[StorageVirtualMachineName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.fsx.model.primitives.StorageVirtualMachineName(value)
      )
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val storageVirtualMachineId: Option[StorageVirtualMachineId] =
      scala
        .Option(impl.storageVirtualMachineId())
        .map(value =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineId(value)
        )
    override val subtype
        : Option[zio.aws.fsx.model.StorageVirtualMachineSubtype] = scala
      .Option(impl.subtype())
      .map(value => zio.aws.fsx.model.StorageVirtualMachineSubtype.wrap(value))
    override val uuid: Option[UUID] = scala
      .Option(impl.uuid())
      .map(value => zio.aws.fsx.model.primitives.UUID(value))
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val lifecycleTransitionReason
        : Option[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly] = scala
      .Option(impl.lifecycleTransitionReason())
      .map(value => zio.aws.fsx.model.LifecycleTransitionReason.wrap(value))
    override val rootVolumeSecurityStyle: Option[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = scala
      .Option(impl.rootVolumeSecurityStyle())
      .map(value =>
        zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
  ): zio.aws.fsx.model.StorageVirtualMachine.ReadOnly = new Wrapper(impl)
}
