package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NetBiosAlias
import scala.jdk.CollectionConverters._
final case class SvmActiveDirectoryConfiguration(
    netBiosName: Option[NetBiosAlias] = None,
    selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.SvmActiveDirectoryConfiguration = {
    import SvmActiveDirectoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SvmActiveDirectoryConfiguration
      .builder()
      .optionallyWith(
        netBiosName.map(value => NetBiosAlias.unwrap(value): java.lang.String)
      )(_.netBiosName)
      .optionallyWith(
        selfManagedActiveDirectoryConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.selfManagedActiveDirectoryConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly =
    zio.aws.fsx.model.SvmActiveDirectoryConfiguration.wrap(buildAwsValue())
}
object SvmActiveDirectoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.SvmActiveDirectoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.SvmActiveDirectoryConfiguration =
      zio.aws.fsx.model.SvmActiveDirectoryConfiguration(
        netBiosName.map(value => value),
        selfManagedActiveDirectoryConfiguration.map(value => value.asEditable)
      )
    def netBiosName: Option[NetBiosAlias]
    def selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly
    ]
    def getNetBiosName: ZIO[Any, AwsError, NetBiosAlias] =
      AwsError.unwrapOptionField("netBiosName", netBiosName)
    def getSelfManagedActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedActiveDirectoryConfiguration",
      selfManagedActiveDirectoryConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SvmActiveDirectoryConfiguration
  ) extends zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly {
    override val netBiosName: Option[NetBiosAlias] = scala
      .Option(impl.netBiosName())
      .map(value => zio.aws.fsx.model.primitives.NetBiosAlias(value))
    override val selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly
    ] = scala
      .Option(impl.selfManagedActiveDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SvmActiveDirectoryConfiguration
  ): zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
