package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.CoolingPeriod
import scala.jdk.CollectionConverters._
final case class TieringPolicy(
    coolingPeriod: Option[CoolingPeriod] = None,
    name: Option[zio.aws.fsx.model.TieringPolicyName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.TieringPolicy = {
    import TieringPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.TieringPolicy
      .builder()
      .optionallyWith(
        coolingPeriod.map(value => CoolingPeriod.unwrap(value): Integer)
      )(_.coolingPeriod)
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.TieringPolicy.ReadOnly =
    zio.aws.fsx.model.TieringPolicy.wrap(buildAwsValue())
}
object TieringPolicy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.TieringPolicy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.TieringPolicy =
      zio.aws.fsx.model.TieringPolicy(
        coolingPeriod.map(value => value),
        name.map(value => value)
      )
    def coolingPeriod: Option[CoolingPeriod]
    def name: Option[zio.aws.fsx.model.TieringPolicyName]
    def getCoolingPeriod: ZIO[Any, AwsError, CoolingPeriod] =
      AwsError.unwrapOptionField("coolingPeriod", coolingPeriod)
    def getName: ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicyName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.TieringPolicy
  ) extends zio.aws.fsx.model.TieringPolicy.ReadOnly {
    override val coolingPeriod: Option[CoolingPeriod] = scala
      .Option(impl.coolingPeriod())
      .map(value => zio.aws.fsx.model.primitives.CoolingPeriod(value))
    override val name: Option[zio.aws.fsx.model.TieringPolicyName] = scala
      .Option(impl.name())
      .map(value => zio.aws.fsx.model.TieringPolicyName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.TieringPolicy
  ): zio.aws.fsx.model.TieringPolicy.ReadOnly = new Wrapper(impl)
}
