package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  Megabytes,
  ClientRequestToken,
  DataRepositoryAssociationId
}
import scala.jdk.CollectionConverters._
final case class UpdateDataRepositoryAssociationRequest(
    associationId: DataRepositoryAssociationId,
    clientRequestToken: Option[ClientRequestToken] = None,
    importedFileChunkSize: Option[Megabytes] = None,
    s3: Option[zio.aws.fsx.model.S3DataRepositoryConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest = {
    import UpdateDataRepositoryAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
      .builder()
      .associationId(
        DataRepositoryAssociationId.unwrap(associationId): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        importedFileChunkSize.map(value => Megabytes.unwrap(value): Integer)
      )(_.importedFileChunkSize)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest.ReadOnly =
    zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateDataRepositoryAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest =
      zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest(
        associationId,
        clientRequestToken.map(value => value),
        importedFileChunkSize.map(value => value),
        s3.map(value => value.asEditable)
      )
    def associationId: DataRepositoryAssociationId
    def clientRequestToken: Option[ClientRequestToken]
    def importedFileChunkSize: Option[Megabytes]
    def s3: Option[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly]
    def getAssociationId: ZIO[Any, Nothing, DataRepositoryAssociationId] =
      ZIO.succeed(associationId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getImportedFileChunkSize: ZIO[Any, AwsError, Megabytes] =
      AwsError.unwrapOptionField("importedFileChunkSize", importedFileChunkSize)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
  ) extends zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest.ReadOnly {
    override val associationId: DataRepositoryAssociationId =
      zio.aws.fsx.model.primitives
        .DataRepositoryAssociationId(impl.associationId())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val importedFileChunkSize: Option[Megabytes] = scala
      .Option(impl.importedFileChunkSize())
      .map(value => zio.aws.fsx.model.primitives.Megabytes(value))
    override val s3
        : Option[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly] =
      scala
        .Option(impl.s3())
        .map(value =>
          zio.aws.fsx.model.S3DataRepositoryConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
  ): zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
