package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDataRepositoryAssociationResponse(
    association: Option[zio.aws.fsx.model.DataRepositoryAssociation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse = {
    import UpdateDataRepositoryAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly =
    zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateDataRepositoryAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse =
      zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse(
        association.map(value => value.asEditable)
      )
    def association
        : Option[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse
  ) extends zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly {
    override val association
        : Option[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly] = scala
      .Option(impl.association())
      .map(value => zio.aws.fsx.model.DataRepositoryAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationResponse
  ): zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
