package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  AutomaticBackupRetentionDays,
  DailyTime,
  WeeklyTime
}
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemLustreConfiguration(
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    autoImportPolicy: Option[zio.aws.fsx.model.AutoImportPolicyType] = None,
    dataCompressionType: Option[zio.aws.fsx.model.DataCompressionType] = None,
    logConfiguration: Option[zio.aws.fsx.model.LustreLogCreateConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration = {
    import UpdateFileSystemLustreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
      .builder()
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(autoImportPolicy.map(value => value.unwrap))(
        _.autoImportPolicy
      )
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.wrap(buildAwsValue())
}
object UpdateFileSystemLustreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemLustreConfiguration =
      zio.aws.fsx.model.UpdateFileSystemLustreConfiguration(
        weeklyMaintenanceStartTime.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        autoImportPolicy.map(value => value),
        dataCompressionType.map(value => value),
        logConfiguration.map(value => value.asEditable)
      )
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def autoImportPolicy: Option[zio.aws.fsx.model.AutoImportPolicyType]
    def dataCompressionType: Option[zio.aws.fsx.model.DataCompressionType]
    def logConfiguration
        : Option[zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly]
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getAutoImportPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.AutoImportPolicyType] =
      AwsError.unwrapOptionField("autoImportPolicy", autoImportPolicy)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
  ) extends zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly {
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val autoImportPolicy
        : Option[zio.aws.fsx.model.AutoImportPolicyType] = scala
      .Option(impl.autoImportPolicy())
      .map(value => zio.aws.fsx.model.AutoImportPolicyType.wrap(value))
    override val dataCompressionType
        : Option[zio.aws.fsx.model.DataCompressionType] = scala
      .Option(impl.dataCompressionType())
      .map(value => zio.aws.fsx.model.DataCompressionType.wrap(value))
    override val logConfiguration
        : Option[zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly] =
      scala
        .Option(impl.logConfiguration())
        .map(value =>
          zio.aws.fsx.model.LustreLogCreateConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreConfiguration
  ): zio.aws.fsx.model.UpdateFileSystemLustreConfiguration.ReadOnly =
    new Wrapper(impl)
}
