package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  WeeklyTime,
  AdminPassword,
  DailyTime,
  AutomaticBackupRetentionDays
}
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemOntapConfiguration(
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    fsxAdminPassword: Option[AdminPassword] = None,
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None,
    diskIopsConfiguration: Option[zio.aws.fsx.model.DiskIopsConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration = {
    import UpdateFileSystemOntapConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        fsxAdminPassword.map(value =>
          AdminPassword.unwrap(value): java.lang.String
        )
      )(_.fsxAdminPassword)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.wrap(buildAwsValue())
}
object UpdateFileSystemOntapConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemOntapConfiguration =
      zio.aws.fsx.model.UpdateFileSystemOntapConfiguration(
        automaticBackupRetentionDays.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        fsxAdminPassword.map(value => value),
        weeklyMaintenanceStartTime.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable)
      )
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def fsxAdminPassword: Option[AdminPassword]
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getFsxAdminPassword: ZIO[Any, AwsError, AdminPassword] =
      AwsError.unwrapOptionField("fsxAdminPassword", fsxAdminPassword)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
  ) extends zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val fsxAdminPassword: Option[AdminPassword] = scala
      .Option(impl.fsxAdminPassword())
      .map(value => zio.aws.fsx.model.primitives.AdminPassword(value))
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] = scala
      .Option(impl.diskIopsConfiguration())
      .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
  ): zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly =
    new Wrapper(impl)
}
