package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  Flag
}
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemOpenZFSConfiguration(
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    copyTagsToBackups: Option[Flag] = None,
    copyTagsToVolumes: Option[Flag] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    throughputCapacity: Option[MegabytesPerSecond] = None,
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None,
    diskIopsConfiguration: Option[zio.aws.fsx.model.DiskIopsConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration = {
    import UpdateFileSystemOpenZFSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        copyTagsToVolumes.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToVolumes)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.wrap(buildAwsValue())
}
object UpdateFileSystemOpenZFSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration =
      zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration(
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        copyTagsToVolumes.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        throughputCapacity.map(value => value),
        weeklyMaintenanceStartTime.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable)
      )
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Option[Flag]
    def copyTagsToVolumes: Option[Flag]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def throughputCapacity: Option[MegabytesPerSecond]
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getCopyTagsToVolumes: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToVolumes", copyTagsToVolumes)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
  ) extends zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Option[Flag] = scala
      .Option(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val copyTagsToVolumes: Option[Flag] = scala
      .Option(impl.copyTagsToVolumes())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val throughputCapacity: Option[MegabytesPerSecond] = scala
      .Option(impl.throughputCapacity())
      .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val diskIopsConfiguration
        : Option[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] = scala
      .Option(impl.diskIopsConfiguration())
      .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
  ): zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly =
    new Wrapper(impl)
}
