package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemResponse(
    fileSystem: Option[zio.aws.fsx.model.FileSystem] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse = {
    import UpdateFileSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse
      .builder()
      .optionallyWith(fileSystem.map(value => value.buildAwsValue()))(
        _.fileSystem
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemResponse.wrap(buildAwsValue())
}
object UpdateFileSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemResponse =
      zio.aws.fsx.model
        .UpdateFileSystemResponse(fileSystem.map(value => value.asEditable))
    def fileSystem: Option[zio.aws.fsx.model.FileSystem.ReadOnly]
    def getFileSystem
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] =
      AwsError.unwrapOptionField("fileSystem", fileSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse
  ) extends zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly {
    override val fileSystem: Option[zio.aws.fsx.model.FileSystem.ReadOnly] =
      scala
        .Option(impl.fileSystem())
        .map(value => zio.aws.fsx.model.FileSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemResponse
  ): zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly = new Wrapper(impl)
}
