package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  DailyTime,
  WeeklyTime
}
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemWindowsConfiguration(
    weeklyMaintenanceStartTime: Option[WeeklyTime] = None,
    dailyAutomaticBackupStartTime: Option[DailyTime] = None,
    automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays] = None,
    throughputCapacity: Option[MegabytesPerSecond] = None,
    selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
    ] = None,
    auditLogConfiguration: Option[
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemWindowsConfiguration = {
    import UpdateFileSystemWindowsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemWindowsConfiguration
      .builder()
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        selfManagedActiveDirectoryConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.selfManagedActiveDirectoryConfiguration)
      .optionallyWith(
        auditLogConfiguration.map(value => value.buildAwsValue())
      )(_.auditLogConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.wrap(buildAwsValue())
}
object UpdateFileSystemWindowsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemWindowsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration =
      zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration(
        weeklyMaintenanceStartTime.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        throughputCapacity.map(value => value),
        selfManagedActiveDirectoryConfiguration.map(value => value.asEditable),
        auditLogConfiguration.map(value => value.asEditable)
      )
    def weeklyMaintenanceStartTime: Option[WeeklyTime]
    def dailyAutomaticBackupStartTime: Option[DailyTime]
    def automaticBackupRetentionDays: Option[AutomaticBackupRetentionDays]
    def throughputCapacity: Option[MegabytesPerSecond]
    def selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly
    ]
    def auditLogConfiguration
        : Option[zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly]
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getSelfManagedActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedActiveDirectoryConfiguration",
      selfManagedActiveDirectoryConfiguration
    )
    def getAuditLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("auditLogConfiguration", auditLogConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemWindowsConfiguration
  ) extends zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.ReadOnly {
    override val weeklyMaintenanceStartTime: Option[WeeklyTime] = scala
      .Option(impl.weeklyMaintenanceStartTime())
      .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dailyAutomaticBackupStartTime: Option[DailyTime] = scala
      .Option(impl.dailyAutomaticBackupStartTime())
      .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Option[AutomaticBackupRetentionDays] = scala
      .Option(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val throughputCapacity: Option[MegabytesPerSecond] = scala
      .Option(impl.throughputCapacity())
      .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly
    ] = scala
      .Option(impl.selfManagedActiveDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
          .wrap(value)
      )
    override val auditLogConfiguration: Option[
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly
    ] = scala
      .Option(impl.auditLogConfiguration())
      .map(value =>
        zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemWindowsConfiguration
  ): zio.aws.fsx.model.UpdateFileSystemWindowsConfiguration.ReadOnly =
    new Wrapper(impl)
}
