package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{Flag, VolumeCapacity, JunctionPath}
import scala.jdk.CollectionConverters._
final case class UpdateOntapVolumeConfiguration(
    junctionPath: Option[JunctionPath] = None,
    securityStyle: Option[zio.aws.fsx.model.SecurityStyle] = None,
    sizeInMegabytes: Option[VolumeCapacity] = None,
    storageEfficiencyEnabled: Option[Flag] = None,
    tieringPolicy: Option[zio.aws.fsx.model.TieringPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration = {
    import UpdateOntapVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
      .builder()
      .optionallyWith(
        junctionPath.map(value => JunctionPath.unwrap(value): java.lang.String)
      )(_.junctionPath)
      .optionallyWith(securityStyle.map(value => value.unwrap))(_.securityStyle)
      .optionallyWith(
        sizeInMegabytes.map(value => VolumeCapacity.unwrap(value): Integer)
      )(_.sizeInMegabytes)
      .optionallyWith(
        storageEfficiencyEnabled.map(value =>
          Flag.unwrap(value): java.lang.Boolean
        )
      )(_.storageEfficiencyEnabled)
      .optionallyWith(tieringPolicy.map(value => value.buildAwsValue()))(
        _.tieringPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateOntapVolumeConfiguration.wrap(buildAwsValue())
}
object UpdateOntapVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateOntapVolumeConfiguration =
      zio.aws.fsx.model.UpdateOntapVolumeConfiguration(
        junctionPath.map(value => value),
        securityStyle.map(value => value),
        sizeInMegabytes.map(value => value),
        storageEfficiencyEnabled.map(value => value),
        tieringPolicy.map(value => value.asEditable)
      )
    def junctionPath: Option[JunctionPath]
    def securityStyle: Option[zio.aws.fsx.model.SecurityStyle]
    def sizeInMegabytes: Option[VolumeCapacity]
    def storageEfficiencyEnabled: Option[Flag]
    def tieringPolicy: Option[zio.aws.fsx.model.TieringPolicy.ReadOnly]
    def getJunctionPath: ZIO[Any, AwsError, JunctionPath] =
      AwsError.unwrapOptionField("junctionPath", junctionPath)
    def getSecurityStyle: ZIO[Any, AwsError, zio.aws.fsx.model.SecurityStyle] =
      AwsError.unwrapOptionField("securityStyle", securityStyle)
    def getSizeInMegabytes: ZIO[Any, AwsError, VolumeCapacity] =
      AwsError.unwrapOptionField("sizeInMegabytes", sizeInMegabytes)
    def getStorageEfficiencyEnabled: ZIO[Any, AwsError, Flag] = AwsError
      .unwrapOptionField("storageEfficiencyEnabled", storageEfficiencyEnabled)
    def getTieringPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      AwsError.unwrapOptionField("tieringPolicy", tieringPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
  ) extends zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly {
    override val junctionPath: Option[JunctionPath] = scala
      .Option(impl.junctionPath())
      .map(value => zio.aws.fsx.model.primitives.JunctionPath(value))
    override val securityStyle: Option[zio.aws.fsx.model.SecurityStyle] = scala
      .Option(impl.securityStyle())
      .map(value => zio.aws.fsx.model.SecurityStyle.wrap(value))
    override val sizeInMegabytes: Option[VolumeCapacity] = scala
      .Option(impl.sizeInMegabytes())
      .map(value => zio.aws.fsx.model.primitives.VolumeCapacity(value))
    override val storageEfficiencyEnabled: Option[Flag] = scala
      .Option(impl.storageEfficiencyEnabled())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val tieringPolicy
        : Option[zio.aws.fsx.model.TieringPolicy.ReadOnly] = scala
      .Option(impl.tieringPolicy())
      .map(value => zio.aws.fsx.model.TieringPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration
  ): zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
