package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.IntegerNoMax
import scala.jdk.CollectionConverters._
final case class UpdateOpenZFSVolumeConfiguration(
    storageCapacityReservationGiB: Option[IntegerNoMax] = None,
    storageCapacityQuotaGiB: Option[IntegerNoMax] = None,
    dataCompressionType: Option[zio.aws.fsx.model.OpenZFSDataCompressionType] =
      None,
    nfsExports: Option[Iterable[zio.aws.fsx.model.OpenZFSNfsExport]] = None,
    userAndGroupQuotas: Option[
      Iterable[zio.aws.fsx.model.OpenZFSUserOrGroupQuota]
    ] = None,
    readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration = {
    import UpdateOpenZFSVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
      .builder()
      .optionallyWith(
        storageCapacityReservationGiB.map(value =>
          IntegerNoMax.unwrap(value): Integer
        )
      )(_.storageCapacityReservationGiB)
      .optionallyWith(
        storageCapacityQuotaGiB.map(value =>
          IntegerNoMax.unwrap(value): Integer
        )
      )(_.storageCapacityQuotaGiB)
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(
        nfsExports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nfsExports)
      .optionallyWith(
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAndGroupQuotas)
      .optionallyWith(
        readOnly.map(value =>
          zio.aws.fsx.model.primitives.ReadOnly.unwrap(value): java.lang.Boolean
        )
      )(_.readOnly)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.wrap(buildAwsValue())
}
object UpdateOpenZFSVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration =
      zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration(
        storageCapacityReservationGiB.map(value => value),
        storageCapacityQuotaGiB.map(value => value),
        dataCompressionType.map(value => value),
        nfsExports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        readOnly.map(value => value)
      )
    def storageCapacityReservationGiB: Option[IntegerNoMax]
    def storageCapacityQuotaGiB: Option[IntegerNoMax]
    def dataCompressionType
        : Option[zio.aws.fsx.model.OpenZFSDataCompressionType]
    def nfsExports: Option[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]]
    def userAndGroupQuotas
        : Option[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]]
    def readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly]
    def getStorageCapacityReservationGiB: ZIO[Any, AwsError, IntegerNoMax] =
      AwsError.unwrapOptionField(
        "storageCapacityReservationGiB",
        storageCapacityReservationGiB
      )
    def getStorageCapacityQuotaGiB: ZIO[Any, AwsError, IntegerNoMax] = AwsError
      .unwrapOptionField("storageCapacityQuotaGiB", storageCapacityQuotaGiB)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OpenZFSDataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getNfsExports: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly
    ]] = AwsError.unwrapOptionField("nfsExports", nfsExports)
    def getUserAndGroupQuotas: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly
    ]] = AwsError.unwrapOptionField("userAndGroupQuotas", userAndGroupQuotas)
    def getReadOnly: ZIO[Any, AwsError, zio.aws.fsx.model.primitives.ReadOnly] =
      AwsError.unwrapOptionField("readOnly", readOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
  ) extends zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly {
    override val storageCapacityReservationGiB: Option[IntegerNoMax] = scala
      .Option(impl.storageCapacityReservationGiB())
      .map(value => zio.aws.fsx.model.primitives.IntegerNoMax(value))
    override val storageCapacityQuotaGiB: Option[IntegerNoMax] = scala
      .Option(impl.storageCapacityQuotaGiB())
      .map(value => zio.aws.fsx.model.primitives.IntegerNoMax(value))
    override val dataCompressionType
        : Option[zio.aws.fsx.model.OpenZFSDataCompressionType] = scala
      .Option(impl.dataCompressionType())
      .map(value => zio.aws.fsx.model.OpenZFSDataCompressionType.wrap(value))
    override val nfsExports
        : Option[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]] = scala
      .Option(impl.nfsExports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.OpenZFSNfsExport.wrap(item)
        }.toList
      )
    override val userAndGroupQuotas
        : Option[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]] =
      scala
        .Option(impl.userAndGroupQuotas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.OpenZFSUserOrGroupQuota.wrap(item)
          }.toList
        )
    override val readOnly: Option[zio.aws.fsx.model.primitives.ReadOnly] = scala
      .Option(impl.readOnly())
      .map(value => zio.aws.fsx.model.primitives.ReadOnly(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateOpenZFSVolumeConfiguration
  ): zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
