package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  SnapshotId,
  SnapshotName,
  ClientRequestToken
}
import scala.jdk.CollectionConverters._
final case class UpdateSnapshotRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    name: SnapshotName,
    snapshotId: SnapshotId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest = {
    import UpdateSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .name(SnapshotName.unwrap(name): java.lang.String)
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateSnapshotRequest.ReadOnly =
    zio.aws.fsx.model.UpdateSnapshotRequest.wrap(buildAwsValue())
}
object UpdateSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateSnapshotRequest =
      zio.aws.fsx.model.UpdateSnapshotRequest(
        clientRequestToken.map(value => value),
        name,
        snapshotId
      )
    def clientRequestToken: Option[ClientRequestToken]
    def name: SnapshotName
    def snapshotId: SnapshotId
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getName: ZIO[Any, Nothing, SnapshotName] = ZIO.succeed(name)
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest
  ) extends zio.aws.fsx.model.UpdateSnapshotRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val name: SnapshotName =
      zio.aws.fsx.model.primitives.SnapshotName(impl.name())
    override val snapshotId: SnapshotId =
      zio.aws.fsx.model.primitives.SnapshotId(impl.snapshotId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest
  ): zio.aws.fsx.model.UpdateSnapshotRequest.ReadOnly = new Wrapper(impl)
}
