package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSnapshotResponse(
    snapshot: Option[zio.aws.fsx.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse = {
    import UpdateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly =
    zio.aws.fsx.model.UpdateSnapshotResponse.wrap(buildAwsValue())
}
object UpdateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateSnapshotResponse = zio.aws.fsx.model
      .UpdateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.fsx.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
  ) extends zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.fsx.model.Snapshot.ReadOnly] = scala
      .Option(impl.snapshot())
      .map(value => zio.aws.fsx.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
  ): zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly = new Wrapper(impl)
}
