package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStorageVirtualMachineResponse(
    storageVirtualMachine: Option[zio.aws.fsx.model.StorageVirtualMachine] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse = {
    import UpdateStorageVirtualMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
      .builder()
      .optionallyWith(
        storageVirtualMachine.map(value => value.buildAwsValue())
      )(_.storageVirtualMachine)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly =
    zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.wrap(buildAwsValue())
}
object UpdateStorageVirtualMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateStorageVirtualMachineResponse =
      zio.aws.fsx.model.UpdateStorageVirtualMachineResponse(
        storageVirtualMachine.map(value => value.asEditable)
      )
    def storageVirtualMachine
        : Option[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly]
    def getStorageVirtualMachine
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachine.ReadOnly] =
      AwsError.unwrapOptionField("storageVirtualMachine", storageVirtualMachine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
  ) extends zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly {
    override val storageVirtualMachine
        : Option[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly] = scala
      .Option(impl.storageVirtualMachine())
      .map(value => zio.aws.fsx.model.StorageVirtualMachine.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
  ): zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly =
    new Wrapper(impl)
}
