package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSvmActiveDirectoryConfiguration(
    selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateSvmActiveDirectoryConfiguration = {
    import UpdateSvmActiveDirectoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateSvmActiveDirectoryConfiguration
      .builder()
      .optionallyWith(
        selfManagedActiveDirectoryConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.selfManagedActiveDirectoryConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration
      .wrap(buildAwsValue())
}
object UpdateSvmActiveDirectoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateSvmActiveDirectoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration =
      zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration(
        selfManagedActiveDirectoryConfiguration.map(value => value.asEditable)
      )
    def selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly
    ]
    def getSelfManagedActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedActiveDirectoryConfiguration",
      selfManagedActiveDirectoryConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSvmActiveDirectoryConfiguration
  ) extends zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration.ReadOnly {
    override val selfManagedActiveDirectoryConfiguration: Option[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates.ReadOnly
    ] = scala
      .Option(impl.selfManagedActiveDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSvmActiveDirectoryConfiguration
  ): zio.aws.fsx.model.UpdateSvmActiveDirectoryConfiguration.ReadOnly =
    new Wrapper(impl)
}
