package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{VolumeName, VolumeId, ClientRequestToken}
import scala.jdk.CollectionConverters._
final case class UpdateVolumeRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    volumeId: VolumeId,
    ontapConfiguration: Option[
      zio.aws.fsx.model.UpdateOntapVolumeConfiguration
    ] = None,
    name: Option[VolumeName] = None,
    openZFSConfiguration: Option[
      zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest = {
    import UpdateVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        name.map(value => VolumeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateVolumeRequest.ReadOnly =
    zio.aws.fsx.model.UpdateVolumeRequest.wrap(buildAwsValue())
}
object UpdateVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateVolumeRequest =
      zio.aws.fsx.model.UpdateVolumeRequest(
        clientRequestToken.map(value => value),
        volumeId,
        ontapConfiguration.map(value => value.asEditable),
        name.map(value => value),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def clientRequestToken: Option[ClientRequestToken]
    def volumeId: VolumeId
    def ontapConfiguration
        : Option[zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly]
    def name: Option[VolumeName]
    def openZFSConfiguration
        : Option[zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getName: ZIO[Any, AwsError, VolumeName] =
      AwsError.unwrapOptionField("name", name)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest
  ) extends zio.aws.fsx.model.UpdateVolumeRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val volumeId: VolumeId =
      zio.aws.fsx.model.primitives.VolumeId(impl.volumeId())
    override val ontapConfiguration
        : Option[zio.aws.fsx.model.UpdateOntapVolumeConfiguration.ReadOnly] =
      scala
        .Option(impl.ontapConfiguration())
        .map(value =>
          zio.aws.fsx.model.UpdateOntapVolumeConfiguration.wrap(value)
        )
    override val name: Option[VolumeName] = scala
      .Option(impl.name())
      .map(value => zio.aws.fsx.model.primitives.VolumeName(value))
    override val openZFSConfiguration
        : Option[zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.ReadOnly] =
      scala
        .Option(impl.openZFSConfiguration())
        .map(value =>
          zio.aws.fsx.model.UpdateOpenZFSVolumeConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest
  ): zio.aws.fsx.model.UpdateVolumeRequest.ReadOnly = new Wrapper(impl)
}
