package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  CreationTime,
  FileSystemId,
  ResourceARN,
  VolumeId,
  VolumeName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Volume(
    creationTime: Option[CreationTime] = None,
    fileSystemId: Option[FileSystemId] = None,
    lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle] = None,
    name: Option[VolumeName] = None,
    ontapConfiguration: Option[zio.aws.fsx.model.OntapVolumeConfiguration] =
      None,
    resourceARN: Option[ResourceARN] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None,
    volumeId: Option[VolumeId] = None,
    volumeType: Option[zio.aws.fsx.model.VolumeType] = None,
    lifecycleTransitionReason: Option[
      zio.aws.fsx.model.LifecycleTransitionReason
    ] = None,
    administrativeActions: Option[
      Iterable[zio.aws.fsx.model.AdministrativeAction]
    ] = None,
    openZFSConfiguration: Option[zio.aws.fsx.model.OpenZFSVolumeConfiguration] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.Volume = {
    import Volume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.Volume
      .builder()
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        name.map(value => VolumeName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        lifecycleTransitionReason.map(value => value.buildAwsValue())
      )(_.lifecycleTransitionReason)
      .optionallyWith(
        administrativeActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.administrativeActions)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.Volume.ReadOnly =
    zio.aws.fsx.model.Volume.wrap(buildAwsValue())
}
object Volume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.Volume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.Volume = zio.aws.fsx.model.Volume(
      creationTime.map(value => value),
      fileSystemId.map(value => value),
      lifecycle.map(value => value),
      name.map(value => value),
      ontapConfiguration.map(value => value.asEditable),
      resourceARN.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      volumeId.map(value => value),
      volumeType.map(value => value),
      lifecycleTransitionReason.map(value => value.asEditable),
      administrativeActions.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      openZFSConfiguration.map(value => value.asEditable)
    )
    def creationTime: Option[CreationTime]
    def fileSystemId: Option[FileSystemId]
    def lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle]
    def name: Option[VolumeName]
    def ontapConfiguration
        : Option[zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly]
    def resourceARN: Option[ResourceARN]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def volumeId: Option[VolumeId]
    def volumeType: Option[zio.aws.fsx.model.VolumeType]
    def lifecycleTransitionReason
        : Option[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly]
    def administrativeActions
        : Option[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]]
    def openZFSConfiguration
        : Option[zio.aws.fsx.model.OpenZFSVolumeConfiguration.ReadOnly]
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.VolumeLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getName: ZIO[Any, AwsError, VolumeName] =
      AwsError.unwrapOptionField("name", name)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.fsx.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getLifecycleTransitionReason: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleTransitionReason",
      lifecycleTransitionReason
    )
    def getAdministrativeActions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.AdministrativeAction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("administrativeActions", administrativeActions)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OpenZFSVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.Volume
  ) extends zio.aws.fsx.model.Volume.ReadOnly {
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val fileSystemId: Option[FileSystemId] = scala
      .Option(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val lifecycle: Option[zio.aws.fsx.model.VolumeLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value => zio.aws.fsx.model.VolumeLifecycle.wrap(value))
    override val name: Option[VolumeName] = scala
      .Option(impl.name())
      .map(value => zio.aws.fsx.model.primitives.VolumeName(value))
    override val ontapConfiguration
        : Option[zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly] = scala
      .Option(impl.ontapConfiguration())
      .map(value => zio.aws.fsx.model.OntapVolumeConfiguration.wrap(value))
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val volumeId: Option[VolumeId] = scala
      .Option(impl.volumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
    override val volumeType: Option[zio.aws.fsx.model.VolumeType] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.fsx.model.VolumeType.wrap(value))
    override val lifecycleTransitionReason
        : Option[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly] = scala
      .Option(impl.lifecycleTransitionReason())
      .map(value => zio.aws.fsx.model.LifecycleTransitionReason.wrap(value))
    override val administrativeActions
        : Option[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]] = scala
      .Option(impl.administrativeActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.AdministrativeAction.wrap(item)
        }.toList
      )
    override val openZFSConfiguration
        : Option[zio.aws.fsx.model.OpenZFSVolumeConfiguration.ReadOnly] = scala
      .Option(impl.openZFSConfiguration())
      .map(value => zio.aws.fsx.model.OpenZFSVolumeConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.Volume
  ): zio.aws.fsx.model.Volume.ReadOnly = new Wrapper(impl)
}
