package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait VolumeFilterName {
  def unwrap: software.amazon.awssdk.services.fsx.model.VolumeFilterName
}
object VolumeFilterName {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.VolumeFilterName
  ): zio.aws.fsx.model.VolumeFilterName = value match {
    case software.amazon.awssdk.services.fsx.model.VolumeFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.VolumeFilterName.FILE_SYSTEM_ID =>
      val r = `file-system-id`
      r
    case software.amazon.awssdk.services.fsx.model.VolumeFilterName.STORAGE_VIRTUAL_MACHINE_ID =>
      val r = `storage-virtual-machine-id`
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.VolumeFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeFilterName =
      software.amazon.awssdk.services.fsx.model.VolumeFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `file-system-id` extends zio.aws.fsx.model.VolumeFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeFilterName =
      software.amazon.awssdk.services.fsx.model.VolumeFilterName.FILE_SYSTEM_ID
  }
  case object `storage-virtual-machine-id`
      extends zio.aws.fsx.model.VolumeFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeFilterName =
      software.amazon.awssdk.services.fsx.model.VolumeFilterName.STORAGE_VIRTUAL_MACHINE_ID
  }
}
