package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait WindowsAccessAuditLogLevel {
  def unwrap
      : software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel
}
object WindowsAccessAuditLogLevel {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel
  ): zio.aws.fsx.model.WindowsAccessAuditLogLevel = value match {
    case software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.SUCCESS_ONLY =>
      val r = SUCCESS_ONLY
      r
    case software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.FAILURE_ONLY =>
      val r = FAILURE_ONLY
      r
    case software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.SUCCESS_AND_FAILURE =>
      val r = SUCCESS_AND_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.WindowsAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.fsx.model.WindowsAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.DISABLED
  }
  case object SUCCESS_ONLY
      extends zio.aws.fsx.model.WindowsAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.SUCCESS_ONLY
  }
  case object FAILURE_ONLY
      extends zio.aws.fsx.model.WindowsAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.FAILURE_ONLY
  }
  case object SUCCESS_AND_FAILURE
      extends zio.aws.fsx.model.WindowsAccessAuditLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel =
      software.amazon.awssdk.services.fsx.model.WindowsAccessAuditLogLevel.SUCCESS_AND_FAILURE
  }
}
