package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.GeneralARN
import scala.jdk.CollectionConverters._
final case class WindowsAuditLogCreateConfiguration(
    fileAccessAuditLogLevel: zio.aws.fsx.model.WindowsAccessAuditLogLevel,
    fileShareAccessAuditLogLevel: zio.aws.fsx.model.WindowsAccessAuditLogLevel,
    auditLogDestination: Option[GeneralARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.WindowsAuditLogCreateConfiguration = {
    import WindowsAuditLogCreateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.WindowsAuditLogCreateConfiguration
      .builder()
      .fileAccessAuditLogLevel(fileAccessAuditLogLevel.unwrap)
      .fileShareAccessAuditLogLevel(fileShareAccessAuditLogLevel.unwrap)
      .optionallyWith(
        auditLogDestination.map(value =>
          GeneralARN.unwrap(value): java.lang.String
        )
      )(_.auditLogDestination)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly =
    zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.wrap(buildAwsValue())
}
object WindowsAuditLogCreateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.WindowsAuditLogCreateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.WindowsAuditLogCreateConfiguration =
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration(
        fileAccessAuditLogLevel,
        fileShareAccessAuditLogLevel,
        auditLogDestination.map(value => value)
      )
    def fileAccessAuditLogLevel: zio.aws.fsx.model.WindowsAccessAuditLogLevel
    def fileShareAccessAuditLogLevel
        : zio.aws.fsx.model.WindowsAccessAuditLogLevel
    def auditLogDestination: Option[GeneralARN]
    def getFileAccessAuditLogLevel
        : ZIO[Any, Nothing, zio.aws.fsx.model.WindowsAccessAuditLogLevel] =
      ZIO.succeed(fileAccessAuditLogLevel)
    def getFileShareAccessAuditLogLevel
        : ZIO[Any, Nothing, zio.aws.fsx.model.WindowsAccessAuditLogLevel] =
      ZIO.succeed(fileShareAccessAuditLogLevel)
    def getAuditLogDestination: ZIO[Any, AwsError, GeneralARN] =
      AwsError.unwrapOptionField("auditLogDestination", auditLogDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.WindowsAuditLogCreateConfiguration
  ) extends zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly {
    override val fileAccessAuditLogLevel
        : zio.aws.fsx.model.WindowsAccessAuditLogLevel =
      zio.aws.fsx.model.WindowsAccessAuditLogLevel
        .wrap(impl.fileAccessAuditLogLevel())
    override val fileShareAccessAuditLogLevel
        : zio.aws.fsx.model.WindowsAccessAuditLogLevel =
      zio.aws.fsx.model.WindowsAccessAuditLogLevel
        .wrap(impl.fileShareAccessAuditLogLevel())
    override val auditLogDestination: Option[GeneralARN] = scala
      .Option(impl.auditLogDestination())
      .map(value => zio.aws.fsx.model.primitives.GeneralARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.WindowsAuditLogCreateConfiguration
  ): zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly =
    new Wrapper(impl)
}
