package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait WindowsDeploymentType {
  def unwrap: software.amazon.awssdk.services.fsx.model.WindowsDeploymentType
}
object WindowsDeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.WindowsDeploymentType
  ): zio.aws.fsx.model.WindowsDeploymentType = value match {
    case software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.MULTI_AZ_1 =>
      val r = MULTI_AZ_1
      r
    case software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.SINGLE_AZ_1 =>
      val r = SINGLE_AZ_1
      r
    case software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.SINGLE_AZ_2 =>
      val r = SINGLE_AZ_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.WindowsDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsDeploymentType =
      software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object MULTI_AZ_1 extends zio.aws.fsx.model.WindowsDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsDeploymentType =
      software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.MULTI_AZ_1
  }
  case object SINGLE_AZ_1 extends zio.aws.fsx.model.WindowsDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsDeploymentType =
      software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.SINGLE_AZ_1
  }
  case object SINGLE_AZ_2 extends zio.aws.fsx.model.WindowsDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.WindowsDeploymentType =
      software.amazon.awssdk.services.fsx.model.WindowsDeploymentType.SINGLE_AZ_2
  }
}
