package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  ResourceARN,
  DirectoryId,
  ActiveDirectoryFullyQualifiedName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActiveDirectoryBackupAttributes(
    domainName: Optional[ActiveDirectoryFullyQualifiedName] = Optional.Absent,
    activeDirectoryId: Optional[DirectoryId] = Optional.Absent,
    resourceARN: Optional[ResourceARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes = {
    import ActiveDirectoryBackupAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
      .builder()
      .optionallyWith(
        domainName.map(value =>
          ActiveDirectoryFullyQualifiedName.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        activeDirectoryId.map(value =>
          DirectoryId.unwrap(value): java.lang.String
        )
      )(_.activeDirectoryId)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly =
    zio.aws.fsx.model.ActiveDirectoryBackupAttributes.wrap(buildAwsValue())
}
object ActiveDirectoryBackupAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.ActiveDirectoryBackupAttributes =
      zio.aws.fsx.model.ActiveDirectoryBackupAttributes(
        domainName.map(value => value),
        activeDirectoryId.map(value => value),
        resourceARN.map(value => value)
      )
    def domainName: Optional[ActiveDirectoryFullyQualifiedName]
    def activeDirectoryId: Optional[DirectoryId]
    def resourceARN: Optional[ResourceARN]
    def getDomainName: ZIO[Any, AwsError, ActiveDirectoryFullyQualifiedName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getActiveDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("activeDirectoryId", activeDirectoryId)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
  ) extends zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly {
    override val domainName: Optional[ActiveDirectoryFullyQualifiedName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainName())
        .map(value =>
          zio.aws.fsx.model.primitives.ActiveDirectoryFullyQualifiedName(value)
        )
    override val activeDirectoryId: Optional[DirectoryId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeDirectoryId())
        .map(value => zio.aws.fsx.model.primitives.DirectoryId(value))
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
  ): zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly = new Wrapper(
    impl
  )
}
