package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{RequestTime, ProgressPercent}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AdministrativeAction(
    administrativeActionType: Optional[
      zio.aws.fsx.model.AdministrativeActionType
    ] = Optional.Absent,
    progressPercent: Optional[ProgressPercent] = Optional.Absent,
    requestTime: Optional[RequestTime] = Optional.Absent,
    status: Optional[zio.aws.fsx.model.Status] = Optional.Absent,
    targetFileSystemValues: Optional[zio.aws.fsx.model.FileSystem] =
      Optional.Absent,
    failureDetails: Optional[
      zio.aws.fsx.model.AdministrativeActionFailureDetails
    ] = Optional.Absent,
    targetVolumeValues: Optional[zio.aws.fsx.model.Volume] = Optional.Absent,
    targetSnapshotValues: Optional[zio.aws.fsx.model.Snapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.AdministrativeAction = {
    import AdministrativeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.AdministrativeAction
      .builder()
      .optionallyWith(administrativeActionType.map(value => value.unwrap))(
        _.administrativeActionType
      )
      .optionallyWith(
        progressPercent.map(value => ProgressPercent.unwrap(value): Integer)
      )(_.progressPercent)
      .optionallyWith(
        requestTime.map(value => RequestTime.unwrap(value): Instant)
      )(_.requestTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        targetFileSystemValues.map(value => value.buildAwsValue())
      )(_.targetFileSystemValues)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(targetVolumeValues.map(value => value.buildAwsValue()))(
        _.targetVolumeValues
      )
      .optionallyWith(targetSnapshotValues.map(value => value.buildAwsValue()))(
        _.targetSnapshotValues
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.AdministrativeAction.ReadOnly =
    zio.aws.fsx.model.AdministrativeAction.wrap(buildAwsValue())
}
object AdministrativeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.AdministrativeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.AdministrativeAction =
      zio.aws.fsx.model.AdministrativeAction(
        administrativeActionType.map(value => value),
        progressPercent.map(value => value),
        requestTime.map(value => value),
        status.map(value => value),
        targetFileSystemValues.map(value => value.asEditable),
        failureDetails.map(value => value.asEditable),
        targetVolumeValues.map(value => value.asEditable),
        targetSnapshotValues.map(value => value.asEditable)
      )
    def administrativeActionType
        : Optional[zio.aws.fsx.model.AdministrativeActionType]
    def progressPercent: Optional[ProgressPercent]
    def requestTime: Optional[RequestTime]
    def status: Optional[zio.aws.fsx.model.Status]
    def targetFileSystemValues: Optional[zio.aws.fsx.model.FileSystem.ReadOnly]
    def failureDetails: Optional[
      zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly
    ]
    def targetVolumeValues: Optional[zio.aws.fsx.model.Volume.ReadOnly]
    def targetSnapshotValues: Optional[zio.aws.fsx.model.Snapshot.ReadOnly]
    def getAdministrativeActionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.AdministrativeActionType] =
      AwsError.unwrapOptionField(
        "administrativeActionType",
        administrativeActionType
      )
    def getProgressPercent: ZIO[Any, AwsError, ProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
    def getRequestTime: ZIO[Any, AwsError, RequestTime] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.fsx.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getTargetFileSystemValues
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] = AwsError
      .unwrapOptionField("targetFileSystemValues", targetFileSystemValues)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getTargetVolumeValues
        : ZIO[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
      AwsError.unwrapOptionField("targetVolumeValues", targetVolumeValues)
    def getTargetSnapshotValues
        : ZIO[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("targetSnapshotValues", targetSnapshotValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.AdministrativeAction
  ) extends zio.aws.fsx.model.AdministrativeAction.ReadOnly {
    override val administrativeActionType
        : Optional[zio.aws.fsx.model.AdministrativeActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administrativeActionType())
        .map(value => zio.aws.fsx.model.AdministrativeActionType.wrap(value))
    override val progressPercent: Optional[ProgressPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressPercent())
        .map(value => zio.aws.fsx.model.primitives.ProgressPercent(value))
    override val requestTime: Optional[RequestTime] = zio.aws.core.internal
      .optionalFromNullable(impl.requestTime())
      .map(value => zio.aws.fsx.model.primitives.RequestTime(value))
    override val status: Optional[zio.aws.fsx.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.fsx.model.Status.wrap(value))
    override val targetFileSystemValues
        : Optional[zio.aws.fsx.model.FileSystem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetFileSystemValues())
        .map(value => zio.aws.fsx.model.FileSystem.wrap(value))
    override val failureDetails: Optional[
      zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failureDetails())
      .map(value =>
        zio.aws.fsx.model.AdministrativeActionFailureDetails.wrap(value)
      )
    override val targetVolumeValues
        : Optional[zio.aws.fsx.model.Volume.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.targetVolumeValues())
      .map(value => zio.aws.fsx.model.Volume.wrap(value))
    override val targetSnapshotValues
        : Optional[zio.aws.fsx.model.Snapshot.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.targetSnapshotValues())
      .map(value => zio.aws.fsx.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.AdministrativeAction
  ): zio.aws.fsx.model.AdministrativeAction.ReadOnly = new Wrapper(impl)
}
