package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoImportPolicy(
    events: Optional[Iterable[zio.aws.fsx.model.EventType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.AutoImportPolicy = {
    import AutoImportPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.AutoImportPolicy
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.AutoImportPolicy.ReadOnly =
    zio.aws.fsx.model.AutoImportPolicy.wrap(buildAwsValue())
}
object AutoImportPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.AutoImportPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.AutoImportPolicy =
      zio.aws.fsx.model.AutoImportPolicy(events.map(value => value))
    def events: Optional[List[zio.aws.fsx.model.EventType]]
    def getEvents: ZIO[Any, AwsError, List[zio.aws.fsx.model.EventType]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.AutoImportPolicy
  ) extends zio.aws.fsx.model.AutoImportPolicy.ReadOnly {
    override val events: Optional[List[zio.aws.fsx.model.EventType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.EventType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.AutoImportPolicy
  ): zio.aws.fsx.model.AutoImportPolicy.ReadOnly = new Wrapper(impl)
}
