package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait AutoImportPolicyType {
  def unwrap: software.amazon.awssdk.services.fsx.model.AutoImportPolicyType
}
object AutoImportPolicyType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.AutoImportPolicyType
  ): zio.aws.fsx.model.AutoImportPolicyType = value match {
    case software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NEW =>
      val r = NEW
      r
    case software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NEW_CHANGED =>
      val r = NEW_CHANGED
      r
    case software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NEW_CHANGED_DELETED =>
      val r = NEW_CHANGED_DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.AutoImportPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AutoImportPolicyType =
      software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.fsx.model.AutoImportPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AutoImportPolicyType =
      software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NONE
  }
  case object NEW extends zio.aws.fsx.model.AutoImportPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AutoImportPolicyType =
      software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NEW
  }
  case object NEW_CHANGED extends zio.aws.fsx.model.AutoImportPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AutoImportPolicyType =
      software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NEW_CHANGED
  }
  case object NEW_CHANGED_DELETED
      extends zio.aws.fsx.model.AutoImportPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AutoImportPolicyType =
      software.amazon.awssdk.services.fsx.model.AutoImportPolicyType.NEW_CHANGED_DELETED
  }
}
