package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  CreationTime,
  ProgressPercent,
  BackupId,
  AWSAccountId,
  ResourceARN,
  KmsKeyId,
  Region
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Backup(
    backupId: BackupId,
    lifecycle: zio.aws.fsx.model.BackupLifecycle,
    failureDetails: Optional[zio.aws.fsx.model.BackupFailureDetails] =
      Optional.Absent,
    `type`: zio.aws.fsx.model.BackupType,
    progressPercent: Optional[ProgressPercent] = Optional.Absent,
    creationTime: CreationTime,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    fileSystem: zio.aws.fsx.model.FileSystem,
    directoryInformation: Optional[
      zio.aws.fsx.model.ActiveDirectoryBackupAttributes
    ] = Optional.Absent,
    ownerId: Optional[AWSAccountId] = Optional.Absent,
    sourceBackupId: Optional[BackupId] = Optional.Absent,
    sourceBackupRegion: Optional[Region] = Optional.Absent,
    resourceType: Optional[zio.aws.fsx.model.ResourceType] = Optional.Absent,
    volume: Optional[zio.aws.fsx.model.Volume] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.Backup = {
    import Backup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.Backup
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .lifecycle(lifecycle.unwrap)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .`type`(`type`.unwrap)
      .optionallyWith(
        progressPercent.map(value => ProgressPercent.unwrap(value): Integer)
      )(_.progressPercent)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .fileSystem(fileSystem.buildAwsValue())
      .optionallyWith(directoryInformation.map(value => value.buildAwsValue()))(
        _.directoryInformation
      )
      .optionallyWith(
        ownerId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        sourceBackupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.sourceBackupId)
      .optionallyWith(
        sourceBackupRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.sourceBackupRegion)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.Backup.ReadOnly =
    zio.aws.fsx.model.Backup.wrap(buildAwsValue())
}
object Backup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.Backup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.Backup = zio.aws.fsx.model.Backup(
      backupId,
      lifecycle,
      failureDetails.map(value => value.asEditable),
      `type`,
      progressPercent.map(value => value),
      creationTime,
      kmsKeyId.map(value => value),
      resourceARN.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      fileSystem.asEditable,
      directoryInformation.map(value => value.asEditable),
      ownerId.map(value => value),
      sourceBackupId.map(value => value),
      sourceBackupRegion.map(value => value),
      resourceType.map(value => value),
      volume.map(value => value.asEditable)
    )
    def backupId: BackupId
    def lifecycle: zio.aws.fsx.model.BackupLifecycle
    def failureDetails
        : Optional[zio.aws.fsx.model.BackupFailureDetails.ReadOnly]
    def `type`: zio.aws.fsx.model.BackupType
    def progressPercent: Optional[ProgressPercent]
    def creationTime: CreationTime
    def kmsKeyId: Optional[KmsKeyId]
    def resourceARN: Optional[ResourceARN]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def fileSystem: zio.aws.fsx.model.FileSystem.ReadOnly
    def directoryInformation
        : Optional[zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly]
    def ownerId: Optional[AWSAccountId]
    def sourceBackupId: Optional[BackupId]
    def sourceBackupRegion: Optional[Region]
    def resourceType: Optional[zio.aws.fsx.model.ResourceType]
    def volume: Optional[zio.aws.fsx.model.Volume.ReadOnly]
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getLifecycle: ZIO[Any, Nothing, zio.aws.fsx.model.BackupLifecycle] =
      ZIO.succeed(lifecycle)
    def getFailureDetails
        : ZIO[Any, AwsError, zio.aws.fsx.model.BackupFailureDetails.ReadOnly] =
      AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getType: ZIO[Any, Nothing, zio.aws.fsx.model.BackupType] =
      ZIO.succeed(`type`)
    def getProgressPercent: ZIO[Any, AwsError, ProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileSystem
        : ZIO[Any, Nothing, zio.aws.fsx.model.FileSystem.ReadOnly] =
      ZIO.succeed(fileSystem)
    def getDirectoryInformation: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("directoryInformation", directoryInformation)
    def getOwnerId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getSourceBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("sourceBackupId", sourceBackupId)
    def getSourceBackupRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("sourceBackupRegion", sourceBackupRegion)
    def getResourceType: ZIO[Any, AwsError, zio.aws.fsx.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getVolume: ZIO[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
      AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.Backup
  ) extends zio.aws.fsx.model.Backup.ReadOnly {
    override val backupId: BackupId =
      zio.aws.fsx.model.primitives.BackupId(impl.backupId())
    override val lifecycle: zio.aws.fsx.model.BackupLifecycle =
      zio.aws.fsx.model.BackupLifecycle.wrap(impl.lifecycle())
    override val failureDetails
        : Optional[zio.aws.fsx.model.BackupFailureDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDetails())
        .map(value => zio.aws.fsx.model.BackupFailureDetails.wrap(value))
    override val `type`: zio.aws.fsx.model.BackupType =
      zio.aws.fsx.model.BackupType.wrap(impl.`type`())
    override val progressPercent: Optional[ProgressPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressPercent())
        .map(value => zio.aws.fsx.model.primitives.ProgressPercent(value))
    override val creationTime: CreationTime =
      zio.aws.fsx.model.primitives.CreationTime(impl.creationTime())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val fileSystem: zio.aws.fsx.model.FileSystem.ReadOnly =
      zio.aws.fsx.model.FileSystem.wrap(impl.fileSystem())
    override val directoryInformation
        : Optional[zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryInformation())
        .map(value =>
          zio.aws.fsx.model.ActiveDirectoryBackupAttributes.wrap(value)
        )
    override val ownerId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.fsx.model.primitives.AWSAccountId(value))
    override val sourceBackupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBackupId())
      .map(value => zio.aws.fsx.model.primitives.BackupId(value))
    override val sourceBackupRegion: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBackupRegion())
      .map(value => zio.aws.fsx.model.primitives.Region(value))
    override val resourceType: Optional[zio.aws.fsx.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.fsx.model.ResourceType.wrap(value))
    override val volume: Optional[zio.aws.fsx.model.Volume.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volume())
        .map(value => zio.aws.fsx.model.Volume.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.Backup
  ): zio.aws.fsx.model.Backup.ReadOnly = new Wrapper(impl)
}
