package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait BackupLifecycle {
  def unwrap: software.amazon.awssdk.services.fsx.model.BackupLifecycle
}
object BackupLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.BackupLifecycle
  ): zio.aws.fsx.model.BackupLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.TRANSFERRING =>
      val r = TRANSFERRING
      r
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.fsx.model.BackupLifecycle.COPYING =>
      val r = COPYING
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.AVAILABLE
  }
  case object CREATING extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.CREATING
  }
  case object TRANSFERRING extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.TRANSFERRING
  }
  case object DELETED extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.DELETED
  }
  case object FAILED extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.FAILED
  }
  case object PENDING extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.PENDING
  }
  case object COPYING extends zio.aws.fsx.model.BackupLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.BackupLifecycle =
      software.amazon.awssdk.services.fsx.model.BackupLifecycle.COPYING
  }
}
