package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait BackupType {
  def unwrap: software.amazon.awssdk.services.fsx.model.BackupType
}
object BackupType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.BackupType
  ): zio.aws.fsx.model.BackupType = value match {
    case software.amazon.awssdk.services.fsx.model.BackupType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.BackupType.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.fsx.model.BackupType.USER_INITIATED =>
      val r = USER_INITIATED
      r
    case software.amazon.awssdk.services.fsx.model.BackupType.AWS_BACKUP =>
      val r = AWS_BACKUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.BackupType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.BackupType =
      software.amazon.awssdk.services.fsx.model.BackupType.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATIC extends zio.aws.fsx.model.BackupType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.BackupType =
      software.amazon.awssdk.services.fsx.model.BackupType.AUTOMATIC
  }
  case object USER_INITIATED extends zio.aws.fsx.model.BackupType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.BackupType =
      software.amazon.awssdk.services.fsx.model.BackupType.USER_INITIATED
  }
  case object AWS_BACKUP extends zio.aws.fsx.model.BackupType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.BackupType =
      software.amazon.awssdk.services.fsx.model.BackupType.AWS_BACKUP
  }
}
