package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{ArchivePath, Flag}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CompletionReport(
    enabled: Flag,
    path: Optional[ArchivePath] = Optional.Absent,
    format: Optional[zio.aws.fsx.model.ReportFormat] = Optional.Absent,
    scope: Optional[zio.aws.fsx.model.ReportScope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CompletionReport = {
    import CompletionReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CompletionReport
      .builder()
      .enabled(Flag.unwrap(enabled): java.lang.Boolean)
      .optionallyWith(
        path.map(value => ArchivePath.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CompletionReport.ReadOnly =
    zio.aws.fsx.model.CompletionReport.wrap(buildAwsValue())
}
object CompletionReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CompletionReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CompletionReport =
      zio.aws.fsx.model.CompletionReport(
        enabled,
        path.map(value => value),
        format.map(value => value),
        scope.map(value => value)
      )
    def enabled: Flag
    def path: Optional[ArchivePath]
    def format: Optional[zio.aws.fsx.model.ReportFormat]
    def scope: Optional[zio.aws.fsx.model.ReportScope]
    def getEnabled: ZIO[Any, Nothing, Flag] = ZIO.succeed(enabled)
    def getPath: ZIO[Any, AwsError, ArchivePath] =
      AwsError.unwrapOptionField("path", path)
    def getFormat: ZIO[Any, AwsError, zio.aws.fsx.model.ReportFormat] =
      AwsError.unwrapOptionField("format", format)
    def getScope: ZIO[Any, AwsError, zio.aws.fsx.model.ReportScope] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CompletionReport
  ) extends zio.aws.fsx.model.CompletionReport.ReadOnly {
    override val enabled: Flag =
      zio.aws.fsx.model.primitives.Flag(impl.enabled())
    override val path: Optional[ArchivePath] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.fsx.model.primitives.ArchivePath(value))
    override val format: Optional[zio.aws.fsx.model.ReportFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.fsx.model.ReportFormat.wrap(value))
    override val scope: Optional[zio.aws.fsx.model.ReportScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.fsx.model.ReportScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CompletionReport
  ): zio.aws.fsx.model.CompletionReport.ReadOnly = new Wrapper(impl)
}
