package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataRepositoryAssociationResponse(
    association: Optional[zio.aws.fsx.model.DataRepositoryAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse = {
    import CreateDataRepositoryAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly =
    zio.aws.fsx.model.CreateDataRepositoryAssociationResponse
      .wrap(buildAwsValue())
}
object CreateDataRepositoryAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateDataRepositoryAssociationResponse =
      zio.aws.fsx.model.CreateDataRepositoryAssociationResponse(
        association.map(value => value.asEditable)
      )
    def association
        : Optional[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse
  ) extends zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly {
    override val association
        : Optional[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.association())
        .map(value => zio.aws.fsx.model.DataRepositoryAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationResponse
  ): zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
