package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  ClientRequestToken,
  FileSystemId,
  DataRepositoryTaskPath
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataRepositoryTaskRequest(
    `type`: zio.aws.fsx.model.DataRepositoryTaskType,
    paths: Optional[Iterable[DataRepositoryTaskPath]] = Optional.Absent,
    fileSystemId: FileSystemId,
    report: zio.aws.fsx.model.CompletionReport,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest = {
    import CreateDataRepositoryTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        paths.map(value =>
          value.map { item =>
            DataRepositoryTaskPath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.paths)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .report(report.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateDataRepositoryTaskRequest.ReadOnly =
    zio.aws.fsx.model.CreateDataRepositoryTaskRequest.wrap(buildAwsValue())
}
object CreateDataRepositoryTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateDataRepositoryTaskRequest =
      zio.aws.fsx.model.CreateDataRepositoryTaskRequest(
        `type`,
        paths.map(value => value),
        fileSystemId,
        report.asEditable,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: zio.aws.fsx.model.DataRepositoryTaskType
    def paths: Optional[List[DataRepositoryTaskPath]]
    def fileSystemId: FileSystemId
    def report: zio.aws.fsx.model.CompletionReport.ReadOnly
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getType: ZIO[Any, Nothing, zio.aws.fsx.model.DataRepositoryTaskType] =
      ZIO.succeed(`type`)
    def getPaths: ZIO[Any, AwsError, List[DataRepositoryTaskPath]] =
      AwsError.unwrapOptionField("paths", paths)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getReport
        : ZIO[Any, Nothing, zio.aws.fsx.model.CompletionReport.ReadOnly] =
      ZIO.succeed(report)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest
  ) extends zio.aws.fsx.model.CreateDataRepositoryTaskRequest.ReadOnly {
    override val `type`: zio.aws.fsx.model.DataRepositoryTaskType =
      zio.aws.fsx.model.DataRepositoryTaskType.wrap(impl.`type`())
    override val paths: Optional[List[DataRepositoryTaskPath]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.DataRepositoryTaskPath(item)
          }.toList
        )
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val report: zio.aws.fsx.model.CompletionReport.ReadOnly =
      zio.aws.fsx.model.CompletionReport.wrap(impl.report())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest
  ): zio.aws.fsx.model.CreateDataRepositoryTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
