package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  SubnetId,
  SecurityGroupId,
  FileSystemTypeVersion,
  ClientRequestToken,
  BackupId,
  KmsKeyId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFileSystemFromBackupRequest(
    backupId: BackupId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    windowsConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration
    ] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration
    ] = Optional.Absent,
    storageType: Optional[zio.aws.fsx.model.StorageType] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    fileSystemTypeVersion: Optional[FileSystemTypeVersion] = Optional.Absent,
    openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest = {
    import CreateFileSystemFromBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(windowsConfiguration.map(value => value.buildAwsValue()))(
        _.windowsConfiguration
      )
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(storageType.map(value => value.unwrap))(_.storageType)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        fileSystemTypeVersion.map(value =>
          FileSystemTypeVersion.unwrap(value): java.lang.String
        )
      )(_.fileSystemTypeVersion)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateFileSystemFromBackupRequest.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemFromBackupRequest.wrap(buildAwsValue())
}
object CreateFileSystemFromBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemFromBackupRequest =
      zio.aws.fsx.model.CreateFileSystemFromBackupRequest(
        backupId,
        clientRequestToken.map(value => value),
        subnetIds,
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        windowsConfiguration.map(value => value.asEditable),
        lustreConfiguration.map(value => value.asEditable),
        storageType.map(value => value),
        kmsKeyId.map(value => value),
        fileSystemTypeVersion.map(value => value),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def backupId: BackupId
    def clientRequestToken: Optional[ClientRequestToken]
    def subnetIds: List[SubnetId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def windowsConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ]
    def lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ]
    def storageType: Optional[zio.aws.fsx.model.StorageType]
    def kmsKeyId: Optional[KmsKeyId]
    def fileSystemTypeVersion: Optional[FileSystemTypeVersion]
    def openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ]
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWindowsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("windowsConfiguration", windowsConfiguration)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getStorageType: ZIO[Any, AwsError, zio.aws.fsx.model.StorageType] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getFileSystemTypeVersion: ZIO[Any, AwsError, FileSystemTypeVersion] =
      AwsError.unwrapOptionField("fileSystemTypeVersion", fileSystemTypeVersion)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest
  ) extends zio.aws.fsx.model.CreateFileSystemFromBackupRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.fsx.model.primitives.BackupId(impl.backupId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val windowsConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.windowsConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.wrap(value)
      )
    override val lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lustreConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemLustreConfiguration.wrap(value)
      )
    override val storageType: Optional[zio.aws.fsx.model.StorageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageType())
        .map(value => zio.aws.fsx.model.StorageType.wrap(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val fileSystemTypeVersion: Optional[FileSystemTypeVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemTypeVersion())
        .map(value => zio.aws.fsx.model.primitives.FileSystemTypeVersion(value))
    override val openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openZFSConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest
  ): zio.aws.fsx.model.CreateFileSystemFromBackupRequest.ReadOnly = new Wrapper(
    impl
  )
}
