package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  Flag
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateFileSystemOpenZFSConfiguration(
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent,
    copyTagsToVolumes: Optional[Flag] = Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    deploymentType: zio.aws.fsx.model.OpenZFSDeploymentType,
    throughputCapacity: MegabytesPerSecond,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    diskIopsConfiguration: Optional[zio.aws.fsx.model.DiskIopsConfiguration] =
      Optional.Absent,
    rootVolumeConfiguration: Optional[
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration = {
    import CreateFileSystemOpenZFSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        copyTagsToVolumes.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToVolumes)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .deploymentType(deploymentType.unwrap)
      .throughputCapacity(
        MegabytesPerSecond.unwrap(throughputCapacity): Integer
      )
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .optionallyWith(
        rootVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.rootVolumeConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.wrap(buildAwsValue())
}
object CreateFileSystemOpenZFSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration =
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration(
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        copyTagsToVolumes.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        deploymentType,
        throughputCapacity,
        weeklyMaintenanceStartTime.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable),
        rootVolumeConfiguration.map(value => value.asEditable)
      )
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Optional[Flag]
    def copyTagsToVolumes: Optional[Flag]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def deploymentType: zio.aws.fsx.model.OpenZFSDeploymentType
    def throughputCapacity: MegabytesPerSecond
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def rootVolumeConfiguration: Optional[
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly
    ]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getCopyTagsToVolumes: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToVolumes", copyTagsToVolumes)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.fsx.model.OpenZFSDeploymentType] =
      ZIO.succeed(deploymentType)
    def getThroughputCapacity: ZIO[Any, Nothing, MegabytesPerSecond] =
      ZIO.succeed(throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
    def getRootVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootVolumeConfiguration",
      rootVolumeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
  ) extends zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val copyTagsToVolumes: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToVolumes())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val deploymentType: zio.aws.fsx.model.OpenZFSDeploymentType =
      zio.aws.fsx.model.OpenZFSDeploymentType.wrap(impl.deploymentType())
    override val throughputCapacity: MegabytesPerSecond =
      zio.aws.fsx.model.primitives.MegabytesPerSecond(impl.throughputCapacity())
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskIopsConfiguration())
        .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
    override val rootVolumeConfiguration: Optional[
      zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rootVolumeConfiguration())
      .map(value =>
        zio.aws.fsx.model.OpenZFSCreateRootVolumeConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemOpenZFSConfiguration
  ): zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly =
    new Wrapper(impl)
}
