package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVolumeFromBackupResponse(
    volume: Optional[zio.aws.fsx.model.Volume] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse = {
    import CreateVolumeFromBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse
      .builder()
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly =
    zio.aws.fsx.model.CreateVolumeFromBackupResponse.wrap(buildAwsValue())
}
object CreateVolumeFromBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateVolumeFromBackupResponse =
      zio.aws.fsx.model
        .CreateVolumeFromBackupResponse(volume.map(value => value.asEditable))
    def volume: Optional[zio.aws.fsx.model.Volume.ReadOnly]
    def getVolume: ZIO[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
      AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse
  ) extends zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly {
    override val volume: Optional[zio.aws.fsx.model.Volume.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volume())
        .map(value => zio.aws.fsx.model.Volume.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupResponse
  ): zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly = new Wrapper(
    impl
  )
}
