package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait DataCompressionType {
  def unwrap: software.amazon.awssdk.services.fsx.model.DataCompressionType
}
object DataCompressionType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.DataCompressionType
  ): zio.aws.fsx.model.DataCompressionType = value match {
    case software.amazon.awssdk.services.fsx.model.DataCompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.DataCompressionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.fsx.model.DataCompressionType.LZ4 =>
      val r = LZ4
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.DataCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataCompressionType =
      software.amazon.awssdk.services.fsx.model.DataCompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.fsx.model.DataCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataCompressionType =
      software.amazon.awssdk.services.fsx.model.DataCompressionType.NONE
  }
  case object LZ4 extends zio.aws.fsx.model.DataCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataCompressionType =
      software.amazon.awssdk.services.fsx.model.DataCompressionType.LZ4
  }
}
