package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.ErrorMessage
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataRepositoryFailureDetails(
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DataRepositoryFailureDetails = {
    import DataRepositoryFailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DataRepositoryFailureDetails
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly =
    zio.aws.fsx.model.DataRepositoryFailureDetails.wrap(buildAwsValue())
}
object DataRepositoryFailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DataRepositoryFailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DataRepositoryFailureDetails =
      zio.aws.fsx.model
        .DataRepositoryFailureDetails(message.map(value => value))
    def message: Optional[ErrorMessage]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryFailureDetails
  ) extends zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly {
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.fsx.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryFailureDetails
  ): zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly = new Wrapper(impl)
}
