package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  CreationTime,
  FileSystemId,
  EndTime,
  StartTime,
  ResourceARN,
  TaskId,
  DataRepositoryTaskPath
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DataRepositoryTask(
    taskId: TaskId,
    lifecycle: zio.aws.fsx.model.DataRepositoryTaskLifecycle,
    `type`: zio.aws.fsx.model.DataRepositoryTaskType,
    creationTime: CreationTime,
    startTime: Optional[StartTime] = Optional.Absent,
    endTime: Optional[EndTime] = Optional.Absent,
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    fileSystemId: FileSystemId,
    paths: Optional[Iterable[DataRepositoryTaskPath]] = Optional.Absent,
    failureDetails: Optional[
      zio.aws.fsx.model.DataRepositoryTaskFailureDetails
    ] = Optional.Absent,
    status: Optional[zio.aws.fsx.model.DataRepositoryTaskStatus] =
      Optional.Absent,
    report: Optional[zio.aws.fsx.model.CompletionReport] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DataRepositoryTask = {
    import DataRepositoryTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DataRepositoryTask
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .lifecycle(lifecycle.unwrap)
      .`type`(`type`.unwrap)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(
        paths.map(value =>
          value.map { item =>
            DataRepositoryTaskPath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.paths)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(report.map(value => value.buildAwsValue()))(_.report)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DataRepositoryTask.ReadOnly =
    zio.aws.fsx.model.DataRepositoryTask.wrap(buildAwsValue())
}
object DataRepositoryTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DataRepositoryTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DataRepositoryTask =
      zio.aws.fsx.model.DataRepositoryTask(
        taskId,
        lifecycle,
        `type`,
        creationTime,
        startTime.map(value => value),
        endTime.map(value => value),
        resourceARN.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileSystemId,
        paths.map(value => value),
        failureDetails.map(value => value.asEditable),
        status.map(value => value.asEditable),
        report.map(value => value.asEditable)
      )
    def taskId: TaskId
    def lifecycle: zio.aws.fsx.model.DataRepositoryTaskLifecycle
    def `type`: zio.aws.fsx.model.DataRepositoryTaskType
    def creationTime: CreationTime
    def startTime: Optional[StartTime]
    def endTime: Optional[EndTime]
    def resourceARN: Optional[ResourceARN]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def fileSystemId: FileSystemId
    def paths: Optional[List[DataRepositoryTaskPath]]
    def failureDetails
        : Optional[zio.aws.fsx.model.DataRepositoryTaskFailureDetails.ReadOnly]
    def status: Optional[zio.aws.fsx.model.DataRepositoryTaskStatus.ReadOnly]
    def report: Optional[zio.aws.fsx.model.CompletionReport.ReadOnly]
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getLifecycle
        : ZIO[Any, Nothing, zio.aws.fsx.model.DataRepositoryTaskLifecycle] =
      ZIO.succeed(lifecycle)
    def getType: ZIO[Any, Nothing, zio.aws.fsx.model.DataRepositoryTaskType] =
      ZIO.succeed(`type`)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getPaths: ZIO[Any, AwsError, List[DataRepositoryTaskPath]] =
      AwsError.unwrapOptionField("paths", paths)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryTaskFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryTaskStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getReport
        : ZIO[Any, AwsError, zio.aws.fsx.model.CompletionReport.ReadOnly] =
      AwsError.unwrapOptionField("report", report)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTask
  ) extends zio.aws.fsx.model.DataRepositoryTask.ReadOnly {
    override val taskId: TaskId =
      zio.aws.fsx.model.primitives.TaskId(impl.taskId())
    override val lifecycle: zio.aws.fsx.model.DataRepositoryTaskLifecycle =
      zio.aws.fsx.model.DataRepositoryTaskLifecycle.wrap(impl.lifecycle())
    override val `type`: zio.aws.fsx.model.DataRepositoryTaskType =
      zio.aws.fsx.model.DataRepositoryTaskType.wrap(impl.`type`())
    override val creationTime: CreationTime =
      zio.aws.fsx.model.primitives.CreationTime(impl.creationTime())
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.fsx.model.primitives.StartTime(value))
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.fsx.model.primitives.EndTime(value))
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val paths: Optional[List[DataRepositoryTaskPath]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.DataRepositoryTaskPath(item)
          }.toList
        )
    override val failureDetails: Optional[
      zio.aws.fsx.model.DataRepositoryTaskFailureDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failureDetails())
      .map(value =>
        zio.aws.fsx.model.DataRepositoryTaskFailureDetails.wrap(value)
      )
    override val status
        : Optional[zio.aws.fsx.model.DataRepositoryTaskStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.fsx.model.DataRepositoryTaskStatus.wrap(value))
    override val report: Optional[zio.aws.fsx.model.CompletionReport.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.report())
        .map(value => zio.aws.fsx.model.CompletionReport.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTask
  ): zio.aws.fsx.model.DataRepositoryTask.ReadOnly = new Wrapper(impl)
}
