package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.DataRepositoryTaskFilterValue
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataRepositoryTaskFilter(
    name: Optional[zio.aws.fsx.model.DataRepositoryTaskFilterName] =
      Optional.Absent,
    values: Optional[Iterable[DataRepositoryTaskFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter = {
    import DataRepositoryTaskFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            DataRepositoryTaskFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DataRepositoryTaskFilter.ReadOnly =
    zio.aws.fsx.model.DataRepositoryTaskFilter.wrap(buildAwsValue())
}
object DataRepositoryTaskFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DataRepositoryTaskFilter =
      zio.aws.fsx.model.DataRepositoryTaskFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[zio.aws.fsx.model.DataRepositoryTaskFilterName]
    def values: Optional[List[DataRepositoryTaskFilterValue]]
    def getName
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataRepositoryTaskFilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[DataRepositoryTaskFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter
  ) extends zio.aws.fsx.model.DataRepositoryTaskFilter.ReadOnly {
    override val name
        : Optional[zio.aws.fsx.model.DataRepositoryTaskFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.fsx.model.DataRepositoryTaskFilterName.wrap(value)
        )
    override val values: Optional[List[DataRepositoryTaskFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.DataRepositoryTaskFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter
  ): zio.aws.fsx.model.DataRepositoryTaskFilter.ReadOnly = new Wrapper(impl)
}
