package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait DataRepositoryTaskLifecycle {
  def unwrap
      : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle
}
object DataRepositoryTaskLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle
  ): zio.aws.fsx.model.DataRepositoryTaskLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.EXECUTING =>
      val r = EXECUTING
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.CANCELING =>
      val r = CANCELING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.DataRepositoryTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.fsx.model.DataRepositoryTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.PENDING
  }
  case object EXECUTING extends zio.aws.fsx.model.DataRepositoryTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.EXECUTING
  }
  case object FAILED extends zio.aws.fsx.model.DataRepositoryTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.FAILED
  }
  case object SUCCEEDED extends zio.aws.fsx.model.DataRepositoryTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.SUCCEEDED
  }
  case object CANCELED extends zio.aws.fsx.model.DataRepositoryTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.CANCELED
  }
  case object CANCELING extends zio.aws.fsx.model.DataRepositoryTaskLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskLifecycle.CANCELING
  }
}
