package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{ClientRequestToken, BackupId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBackupRequest(
    backupId: BackupId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteBackupRequest = {
    import DeleteBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteBackupRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteBackupRequest.ReadOnly =
    zio.aws.fsx.model.DeleteBackupRequest.wrap(buildAwsValue())
}
object DeleteBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteBackupRequest = zio.aws.fsx.model
      .DeleteBackupRequest(backupId, clientRequestToken.map(value => value))
    def backupId: BackupId
    def clientRequestToken: Optional[ClientRequestToken]
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteBackupRequest
  ) extends zio.aws.fsx.model.DeleteBackupRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.fsx.model.primitives.BackupId(impl.backupId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteBackupRequest
  ): zio.aws.fsx.model.DeleteBackupRequest.ReadOnly = new Wrapper(impl)
}
