package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.BackupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBackupResponse(
    backupId: Optional[BackupId] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.BackupLifecycle] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteBackupResponse = {
    import DeleteBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteBackupResponse
      .builder()
      .optionallyWith(
        backupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.backupId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteBackupResponse.ReadOnly =
    zio.aws.fsx.model.DeleteBackupResponse.wrap(buildAwsValue())
}
object DeleteBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteBackupResponse =
      zio.aws.fsx.model.DeleteBackupResponse(
        backupId.map(value => value),
        lifecycle.map(value => value)
      )
    def backupId: Optional[BackupId]
    def lifecycle: Optional[zio.aws.fsx.model.BackupLifecycle]
    def getBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("backupId", backupId)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.BackupLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteBackupResponse
  ) extends zio.aws.fsx.model.DeleteBackupResponse.ReadOnly {
    override val backupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.backupId())
      .map(value => zio.aws.fsx.model.primitives.BackupId(value))
    override val lifecycle: Optional[zio.aws.fsx.model.BackupLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.BackupLifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteBackupResponse
  ): zio.aws.fsx.model.DeleteBackupResponse.ReadOnly = new Wrapper(impl)
}
