package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.Flag
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemLustreConfiguration(
    skipFinalBackup: Optional[Flag] = Optional.Absent,
    finalBackupTags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreConfiguration = {
    import DeleteFileSystemLustreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreConfiguration
      .builder()
      .optionallyWith(
        skipFinalBackup.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.skipFinalBackup)
      .optionallyWith(
        finalBackupTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.finalBackupTags)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.wrap(buildAwsValue())
}
object DeleteFileSystemLustreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemLustreConfiguration =
      zio.aws.fsx.model.DeleteFileSystemLustreConfiguration(
        skipFinalBackup.map(value => value),
        finalBackupTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def skipFinalBackup: Optional[Flag]
    def finalBackupTags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getSkipFinalBackup: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("skipFinalBackup", skipFinalBackup)
    def getFinalBackupTags
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("finalBackupTags", finalBackupTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreConfiguration
  ) extends zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.ReadOnly {
    override val skipFinalBackup: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.skipFinalBackup())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val finalBackupTags
        : Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] = zio.aws.core.internal
      .optionalFromNullable(impl.finalBackupTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreConfiguration
  ): zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.ReadOnly =
    new Wrapper(impl)
}
