package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.BackupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemLustreResponse(
    finalBackupId: Optional[BackupId] = Optional.Absent,
    finalBackupTags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreResponse = {
    import DeleteFileSystemLustreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreResponse
      .builder()
      .optionallyWith(
        finalBackupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.finalBackupId)
      .optionallyWith(
        finalBackupTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.finalBackupTags)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemLustreResponse.wrap(buildAwsValue())
}
object DeleteFileSystemLustreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemLustreResponse =
      zio.aws.fsx.model.DeleteFileSystemLustreResponse(
        finalBackupId.map(value => value),
        finalBackupTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def finalBackupId: Optional[BackupId]
    def finalBackupTags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getFinalBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("finalBackupId", finalBackupId)
    def getFinalBackupTags
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("finalBackupTags", finalBackupTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreResponse
  ) extends zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly {
    override val finalBackupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.finalBackupId())
      .map(value => zio.aws.fsx.model.primitives.BackupId(value))
    override val finalBackupTags
        : Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] = zio.aws.core.internal
      .optionalFromNullable(impl.finalBackupTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemLustreResponse
  ): zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly = new Wrapper(
    impl
  )
}
