package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{ClientRequestToken, FileSystemId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemRequest(
    fileSystemId: FileSystemId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    windowsConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemWindowsConfiguration
    ] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemLustreConfiguration
    ] = Optional.Absent,
    openZFSConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest = {
    import DeleteFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(windowsConfiguration.map(value => value.buildAwsValue()))(
        _.windowsConfiguration
      )
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileSystemRequest.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemRequest.wrap(buildAwsValue())
}
object DeleteFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemRequest =
      zio.aws.fsx.model.DeleteFileSystemRequest(
        fileSystemId,
        clientRequestToken.map(value => value),
        windowsConfiguration.map(value => value.asEditable),
        lustreConfiguration.map(value => value.asEditable),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def fileSystemId: FileSystemId
    def clientRequestToken: Optional[ClientRequestToken]
    def windowsConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemWindowsConfiguration.ReadOnly
    ]
    def lustreConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.ReadOnly
    ]
    def openZFSConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.ReadOnly
    ]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getWindowsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemWindowsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("windowsConfiguration", windowsConfiguration)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest
  ) extends zio.aws.fsx.model.DeleteFileSystemRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val windowsConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemWindowsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.windowsConfiguration())
      .map(value =>
        zio.aws.fsx.model.DeleteFileSystemWindowsConfiguration.wrap(value)
      )
    override val lustreConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lustreConfiguration())
      .map(value =>
        zio.aws.fsx.model.DeleteFileSystemLustreConfiguration.wrap(value)
      )
    override val openZFSConfiguration: Optional[
      zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openZFSConfiguration())
      .map(value =>
        zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest
  ): zio.aws.fsx.model.DeleteFileSystemRequest.ReadOnly = new Wrapper(impl)
}
