package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.FileSystemId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFileSystemResponse(
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.FileSystemLifecycle] =
      Optional.Absent,
    windowsResponse: Optional[
      zio.aws.fsx.model.DeleteFileSystemWindowsResponse
    ] = Optional.Absent,
    lustreResponse: Optional[zio.aws.fsx.model.DeleteFileSystemLustreResponse] =
      Optional.Absent,
    openZFSResponse: Optional[
      zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse = {
    import DeleteFileSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
      .builder()
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(windowsResponse.map(value => value.buildAwsValue()))(
        _.windowsResponse
      )
      .optionallyWith(lustreResponse.map(value => value.buildAwsValue()))(
        _.lustreResponse
      )
      .optionallyWith(openZFSResponse.map(value => value.buildAwsValue()))(
        _.openZFSResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemResponse.wrap(buildAwsValue())
}
object DeleteFileSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemResponse =
      zio.aws.fsx.model.DeleteFileSystemResponse(
        fileSystemId.map(value => value),
        lifecycle.map(value => value),
        windowsResponse.map(value => value.asEditable),
        lustreResponse.map(value => value.asEditable),
        openZFSResponse.map(value => value.asEditable)
      )
    def fileSystemId: Optional[FileSystemId]
    def lifecycle: Optional[zio.aws.fsx.model.FileSystemLifecycle]
    def windowsResponse
        : Optional[zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly]
    def lustreResponse
        : Optional[zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly]
    def openZFSResponse
        : Optional[zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly]
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getWindowsResponse: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("windowsResponse", windowsResponse)
    def getLustreResponse: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly
    ] = AwsError.unwrapOptionField("lustreResponse", lustreResponse)
    def getOpenZFSResponse: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSResponse", openZFSResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
  ) extends zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly {
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val lifecycle: Optional[zio.aws.fsx.model.FileSystemLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.FileSystemLifecycle.wrap(value))
    override val windowsResponse
        : Optional[zio.aws.fsx.model.DeleteFileSystemWindowsResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowsResponse())
        .map(value =>
          zio.aws.fsx.model.DeleteFileSystemWindowsResponse.wrap(value)
        )
    override val lustreResponse
        : Optional[zio.aws.fsx.model.DeleteFileSystemLustreResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lustreResponse())
        .map(value =>
          zio.aws.fsx.model.DeleteFileSystemLustreResponse.wrap(value)
        )
    override val openZFSResponse
        : Optional[zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openZFSResponse())
        .map(value =>
          zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemResponse
  ): zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly = new Wrapper(impl)
}
