package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  NextToken,
  LimitedMaxResults,
  DataRepositoryAssociationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDataRepositoryAssociationsRequest(
    associationIds: Optional[Iterable[DataRepositoryAssociationId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.fsx.model.Filter]] = Optional.Absent,
    maxResults: Optional[LimitedMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest = {
    import DescribeDataRepositoryAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest
      .builder()
      .optionallyWith(
        associationIds.map(value =>
          value.map { item =>
            DataRepositoryAssociationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associationIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => LimitedMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeDataRepositoryAssociationsRequest.ReadOnly =
    zio.aws.fsx.model.DescribeDataRepositoryAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeDataRepositoryAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fsx.model.DescribeDataRepositoryAssociationsRequest =
      zio.aws.fsx.model.DescribeDataRepositoryAssociationsRequest(
        associationIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def associationIds: Optional[List[DataRepositoryAssociationId]]
    def filters: Optional[List[zio.aws.fsx.model.Filter.ReadOnly]]
    def maxResults: Optional[LimitedMaxResults]
    def nextToken: Optional[NextToken]
    def getAssociationIds
        : ZIO[Any, AwsError, List[DataRepositoryAssociationId]] =
      AwsError.unwrapOptionField("associationIds", associationIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, LimitedMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest
  ) extends zio.aws.fsx.model.DescribeDataRepositoryAssociationsRequest.ReadOnly {
    override val associationIds: Optional[List[DataRepositoryAssociationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.DataRepositoryAssociationId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.fsx.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[LimitedMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.LimitedMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest
  ): zio.aws.fsx.model.DescribeDataRepositoryAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
