package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  NextToken,
  MaxResults,
  FileSystemId,
  ClientRequestToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemAliasesRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    fileSystemId: FileSystemId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest = {
    import DescribeFileSystemAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileSystemAliasesRequest.ReadOnly =
    zio.aws.fsx.model.DescribeFileSystemAliasesRequest.wrap(buildAwsValue())
}
object DescribeFileSystemAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileSystemAliasesRequest =
      zio.aws.fsx.model.DescribeFileSystemAliasesRequest(
        clientRequestToken.map(value => value),
        fileSystemId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def fileSystemId: FileSystemId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest
  ) extends zio.aws.fsx.model.DescribeFileSystemAliasesRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest
  ): zio.aws.fsx.model.DescribeFileSystemAliasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
