package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemAliasesResponse(
    aliases: Optional[Iterable[zio.aws.fsx.model.Alias]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse = {
    import DescribeFileSystemAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
      .builder()
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly =
    zio.aws.fsx.model.DescribeFileSystemAliasesResponse.wrap(buildAwsValue())
}
object DescribeFileSystemAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileSystemAliasesResponse =
      zio.aws.fsx.model.DescribeFileSystemAliasesResponse(
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aliases: Optional[List[zio.aws.fsx.model.Alias.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAliases: ZIO[Any, AwsError, List[zio.aws.fsx.model.Alias.ReadOnly]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
  ) extends zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly {
    override val aliases: Optional[List[zio.aws.fsx.model.Alias.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Alias.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesResponse
  ): zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
