package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, FileSystemId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFileSystemsRequest(
    fileSystemIds: Optional[Iterable[FileSystemId]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest = {
    import DescribeFileSystemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
      .builder()
      .optionallyWith(
        fileSystemIds.map(value =>
          value.map { item =>
            FileSystemId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fileSystemIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileSystemsRequest.ReadOnly =
    zio.aws.fsx.model.DescribeFileSystemsRequest.wrap(buildAwsValue())
}
object DescribeFileSystemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileSystemsRequest =
      zio.aws.fsx.model.DescribeFileSystemsRequest(
        fileSystemIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def fileSystemIds: Optional[List[FileSystemId]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getFileSystemIds: ZIO[Any, AwsError, List[FileSystemId]] =
      AwsError.unwrapOptionField("fileSystemIds", fileSystemIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
  ) extends zio.aws.fsx.model.DescribeFileSystemsRequest.ReadOnly {
    override val fileSystemIds: Optional[List[FileSystemId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.FileSystemId(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest
  ): zio.aws.fsx.model.DescribeFileSystemsRequest.ReadOnly = new Wrapper(impl)
}
